-- examples of arguments using plpgsql

DROP FUNCTION IF EXISTS hello_world();
DROP FUNCTION IF EXISTS echo(text);

CREATE OR REPLACE FUNCTION hello_world (
  OUT greetings text
) AS
$$
BEGIN
  greetings :='hello world';
END;
$$
LANGUAGE PLPGSQL;

/*
select * from hello_world();
*/

CREATE OR REPLACE FUNCTION echo (
  IN  str_in    text,
  OUT str_out   text
) AS
$$
BEGIN
  str_out := str_in;
END;
$$
LANGUAGE PLPGSQL;

/*
\df+ echo
select * from echo('Robert');
*/

DROP FUNCTION IF EXISTS echo(text);

CREATE OR REPLACE FUNCTION echo (
  INOUT str_inout text
) AS
$$
BEGIN
  raise notice 'function invoked';
  return;
END;
$$
LANGUAGE PLPGSQL;

/*
select * from echo('Robert Bernier');
select * from echo(NULL);
*/

CREATE OR REPLACE FUNCTION echo (
  INOUT str_inout text
) AS
$$
BEGIN
  raise notice 'function invoked';
  return;
END;
$$
LANGUAGE PLPGSQL
RETURNS NULL ON NULL INPUT; -- STRICT

CREATE OR REPLACE FUNCTION echo ()
  RETURNS VOID AS
$$
BEGIN
  raise notice 'VOID function invoked';
  return;
END;
$$
LANGUAGE PLPGSQL;


/*
select * from echo('Robert Bernier');
select * from echo(null);
select * from echo();
*/

CREATE OR REPLACE FUNCTION echo (
  IN  a integer,
  IN  b integer,
  OUT c integer
) AS
$$
BEGIN
  c := a-b;
  raise notice 'integer function invoked c=%',c;
END;
$$
LANGUAGE PLPGSQL
STRICT;

/*
select * from echo(1,2);
select * from echo(1,0);
select * from echo(1,null);
select * from echo(a:=3,b:=2);
select * from echo(b:=3,a:=2);
*/

CREATE OR REPLACE FUNCTION concat (
  IN  a text default 'ham',
  IN  b text default 'eggs',
  OUT c text
) AS
$$
BEGIN
  select a || ' ' || b into c;
END;
$$
LANGUAGE PLPGSQL
STRICT;

/*
select * from concat('cat','hat');
select * from concat(a:='green');
select * from concat(b:='hocks');
select * from concat();
*/

